/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.util.concurrent.atomic.AtomicInteger;
import net.creeperhost.minetogether.MineTogetherClient;
import net.creeperhost.minetogether.connect.ConnectHandler;
import net.creeperhost.minetogether.connect.ConnectHost;
import net.creeperhost.minetogether.connect.FriendServerData;
import net.creeperhost.minetogether.connect.RemoteServer;
import net.creeperhost.minetogether.connect.netty.NettyClient;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.session.JWebToken;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientHandshakePacketListenerImpl;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import org.slf4j.Logger;

public class FriendConnectScreen
extends ConnectScreen {
    private static final AtomicInteger UNIQUE_THREAD_ID = new AtomicInteger(0);
    private static final Logger LOGGER = LogUtils.getLogger();
    private volatile boolean aborted;
    private final Screen parent;
    private Component status = new TranslatableComponent("connect.connecting");
    private long lastNarration = -1L;

    private FriendConnectScreen(Screen screen) {
        super(screen);
        this.parent = screen;
    }

    public static void startConnecting(Screen screen, Minecraft minecraft, RemoteServer server) {
        FriendConnectScreen connectScreen = new FriendConnectScreen(screen);
        minecraft.m_91399_();
        minecraft.m_193588_();
        minecraft.m_91158_((ServerData)new FriendServerData(server));
        minecraft.m_91152_((Screen)connectScreen);
        connectScreen.connect(minecraft, server);
    }

    private void connect(final Minecraft minecraft, final RemoteServer server) {
        Profile profile = ConnectHandler.getServerProfile(server);
        if (profile != null) {
            LOGGER.info("Connecting to MF Friend Server: {}", (Object)(profile.isFriend() ? profile.getFriendName() : profile.getDisplayName()));
        }
        Thread thread = new Thread("MT Server Connector #" + UNIQUE_THREAD_ID.incrementAndGet()){

            @Override
            public void run() {
                try {
                    if (FriendConnectScreen.this.aborted) {
                        return;
                    }
                    ConnectHost endpoint = ConnectHandler.getSpecificEndpoint(server.node);
                    JWebToken token = (JWebToken)MineTogetherClient.getSession().get().orThrow();
                    FriendConnectScreen.this.f_95684_ = NettyClient.connect(endpoint, token, server.serverToken);
                    FriendConnectScreen.this.f_95684_.m_129505_((PacketListener)new ClientHandshakePacketListenerImpl(FriendConnectScreen.this.f_95684_, minecraft, FriendConnectScreen.this.parent, FriendConnectScreen.this::updateStatus));
                    FriendConnectScreen.this.f_95684_.m_129512_((Packet)new ClientIntentionPacket(endpoint.address(), endpoint.proxyPort(), ConnectionProtocol.LOGIN));
                    FriendConnectScreen.this.f_95684_.m_129512_((Packet)new ServerboundHelloPacket(minecraft.m_91094_().m_92548_()));
                }
                catch (Exception ex) {
                    Exception e;
                    if (FriendConnectScreen.this.aborted) {
                        return;
                    }
                    LOGGER.error("Couldn't connect to server", (Throwable)ex);
                    Throwable throwable = ex.getCause();
                    Exception loggedException = throwable instanceof Exception ? (e = (Exception)throwable) : ex;
                    String string = loggedException.getMessage();
                    minecraft.execute(() -> minecraft.m_91152_((Screen)new DisconnectedScreen(FriendConnectScreen.this.parent, CommonComponents.f_130661_, (Component)new TranslatableComponent("disconnect.genericReason", new Object[]{string}))));
                }
            }
        };
        thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER));
        thread.start();
    }

    private void updateStatus(Component component) {
        this.status = component;
    }

    public void m_96624_() {
        if (this.f_95684_ != null) {
            if (this.f_95684_.m_129536_()) {
                this.f_95684_.m_129483_();
            } else {
                this.f_95684_.m_129541_();
            }
        }
    }

    public boolean m_6913_() {
        return false;
    }

    protected void m_7856_() {
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 120 + 12, 200, 20, CommonComponents.f_130656_, button -> {
            this.aborted = true;
            if (this.f_95684_ != null) {
                this.f_95684_.m_129507_((Component)new TranslatableComponent("connect.aborted"));
            }
            this.f_96541_.m_91152_(this.parent);
        }));
    }

    public void m_6305_(PoseStack poseStack, int i, int j, float f) {
        this.m_7333_(poseStack);
        long l = Util.m_137550_();
        if (l - this.lastNarration > 2000L) {
            this.lastNarration = l;
            NarratorChatListener.f_93311_.m_168785_((Component)new TranslatableComponent("narrator.joining"));
        }
        FriendConnectScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.status, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 50), (int)0xFFFFFF);
        super.m_6305_(poseStack, i, j, f);
    }
}

